module.exports = {
    name: "Cron Job [Event]",

    description: "Make a Time Specific Event",

    category: "Events",

    auto_execute: true,

    inputs: [
        {     
            "id": "cronInfo",
            "name": "Cron Text",
            "description": "example: * * * * * * for every seconds",
            "types": ["text", "unspecified"]
        }
    ],

    options: [
        {     
            "id": "cronInfo",
            "name": "Cron Text",
            "description": "example: * * * * * * for every seconds",
            "type": "TEXT"
        },
        {     
            "id": "timezone",
            "name": "TimeZone",
            "description": "Pick  the timezone of your cronjob event (Optional)",
            "type": "SELECT",
            "options": {
                "Etc/GMT+12": "Etc/GMT+12",	
                "Pacific/Pago_Pago": "Pacific/Pago_Pago",
                "Pacific/Midway": "Pacific/Midway",
                "Pacific/Honolulu": "Pacific/Honolulu",
                "America/Juneau": "America/Juneau",
                "America/Los_Angeles": "America/Los_Angeles",
                "America/Tijuana": "America/Tijuana",
                "America/Phoenix": "America/Phoenix",
                "America/Chihuahua": "America/Chihuahua",
                "America/Mazatlan": "America/Mazatlan",
                "America/Denver": "America/Denver",
                "America/Guatemala": "America/Guatemala",
                "America/Chicago": "America/Chicago",
                "America/Mexico_City": "America/Mexico_City",
                "America/Monterrey": "America/Monterrey",
                "America/Regina": "America/Regina",
                "America/Bogota": "America/Bogota",
                "America/New_York": "America/New_York",
                "America/Indiana/Indianapolis": "America/Indiana/Indianapolis",
                "America/Lima": "America/Lima",
                "America/Halifax": "America/Halifax",
                "America/Caracas": "America/Caracas",
                "America/Guyana": "America/Guyana",
                "America/La_Paz": "America/La_Paz",
                "America/Puerto_Rico": "America/Puerto_Rico",
                "America/Santiago": "America/Santiago",
                "America/St_Johns": "America/St_Johns",
                "America/Sao_Paulo": "America/Sao_Paulo",
                "America/Argentina/Buenos_Aires": "America/Argentina/Buenos_Aires",
                "America/Godthab": "America/Godthab",
                "America/Montevideo": "America/Montevideo",
                "Atlantic/South_Georgia": "Atlantic/South_Georgia",
                "Atlantic/Azores": "Atlantic/Azores",
                "Atlantic/Cape_Verde": "Atlantic/Cape_Verde",
                "Africa/Casablanca": "Africa/Casablanca",
                "Europe/London": "Europe/London",
                "Europe/Lisbon": "Europe/Lisbon",
                "Africa/Monrovia": "Africa/Monrovia",
                "Etc/UTC": "Etc/UTC",
                "Europe/Amsterdam": "Europe/Amsterdam",
                "Europe/Belgrade": "Europe/Belgrade",
                "Europe/Berlin": "Europe/Berlin",
                "Europe/Zurich": "Europe/Zurich",
                "Europe/Bratislava": "Europe/Bratislava",
                "Europe/Brussels": "Europe/Brussels",
                "Europe/Budapest": "Europe/Budapest",
                "Europe/Copenhagen": "Europe/Copenhagen",
                "Europe/Dublin": "Europe/Dublin",
                "Europe/Ljubljana": "Europe/Ljubljana",
                "Europe/Madrid": "Europe/Madrid",
                "Europe/Paris": "Europe/Paris",
                "Europe/Prague": "Europe/Prague",
                "Europe/Rome": "Europe/Rome",
                "Europe/Sarajevo": "Europe/Sarajevo",
                "Europe/Skopje": "Europe/Skopje",
                "Europe/Stockholm": "Europe/Stockholm",
                "Europe/Vienna": "Europe/Vienna",
                "Europe/Warsaw": "Europe/Warsaw",
                "Africa/Algiers": "Africa/Algiers",
                "Europe/Zagreb": "Europe/Zagreb",
                "Europe/Athens": "Europe/Athens",
                "Europe/Bucharest": "Europe/Bucharest",
                "Africa/Cairo": "Africa/Cairo",
                "Africa/Harare": "Africa/Harare",
                "Europe/Helsinki": "Europe/Helsinki",
                "Asia/Jerusalem": "Asia/Jerusalem",
                "Europe/Kaliningrad": "Europe/Kaliningrad",
                "Europe/Kiev": "Europe/Kiev",
                "Africa/Johannesburg": "Africa/Johannesburg",
                "Europe/Riga": "Europe/Riga",
                "Europe/Sofia": "Europe/Sofia",
                "Europe/Tallinn": "Europe/Tallinn",
                "Europe/Vilnius": "Europe/Vilnius",
                "Asia/Baghdad": "Asia/Baghdad",
                "Europe/Istanbul": "Europe/Istanbul",
                "Asia/Kuwait": "Asia/Kuwait",
                "Europe/Minsk": "Europe/Minsk",
                "Europe/Moscow": "Europe/Moscow",
                "Africa/Nairobi": "Africa/Nairobi",
                "Asia/Riyadh": "Asia/Riyadh",
                "Europe/Volgograd": "Europe/Volgograd",
                "Asia/Tehran": "Asia/Tehran",
                "Asia/Muscat": "Asia/Muscat",
                "Asia/Baku": "Asia/Baku",
                "Europe/Samara": "Europe/Samara",
                "Asia/Tbilisi": "Asia/Tbilisi",
                "Asia/Yerevan": "Asia/Yerevan",
                "Asia/Kabul": "Asia/Kabul",
                "Asia/Yekaterinburg": "Asia/Yekaterinburg",
                "Asia/Karachi": "Asia/Karachi",
                "Asia/Tashkent": "Asia/Tashkent",
                "Asia/Kolkata": "Asia/Kolkata",
                "Asia/Colombo": "Asia/Colombo",
                "Asia/Kathmandu": "Asia/Kathmandu",
                "Asia/Almaty": "Asia/Almaty",
                "Asia/Dhaka": "Asia/Dhaka",
                "Asia/Urumqi": "Asia/Urumqi",
                "Asia/Rangoon": "Asia/Rangoon",
                "Asia/Bangkok": "Asia/Bangkok",
                "Asia/Jakarta": "Asia/Jakarta",
                "Asia/Krasnoyarsk": "Asia/Krasnoyarsk",
                "Asia/Novosibirsk": "Asia/Novosibirsk",
                "Asia/Shanghai": "Asia/Shanghai",
                "Asia/Chongqing": "Asia/Chongqing",
                "Asia/Hong_Kong": "Asia/Hong_Kong",
                "Asia/Irkutsk": "Asia/Irkutsk",
                "Asia/Kuala_Lumpur": "Asia/Kuala_Lumpur",
                "Australia/Perth": "Australia/Perth",
                "Asia/Singapore": "Asia/Singapore",
                "Asia/Taipei": "Asia/Taipei",
                "Asia/Ulaanbaatar": "Asia/Ulaanbaatar",
                "Asia/Tokyo": "Asia/Tokyo",
                "Asia/Seoul": "Asia/Seoul",
                "Asia/Yakutsk": "Asia/Yakutsk",
                "Australia/Adelaide": "Australia/Adelaide",
                "Australia/Darwin": "Australia/Darwin",
                "Australia/Brisbane": "Australia/Brisbane",
                "Australia/Melbourne": "Australia/Melbourne",
                "Pacific/Guam": "Pacific/Guam",
                "Australia/Hobart": "Australia/Hobart",
                "Pacific/Port_Moresby": "Pacific/Port_Moresby",
                "Australia/Sydney": "Australia/Sydney",
                "Asia/Vladivostok": "Asia/Vladivostok",
                "Asia/Magadan": "Asia/Magadan",
                "Pacific/Noumea": "Pacific/Noumea",
                "Pacific/Guadalcanal": "Pacific/Guadalcanal",
                "Asia/Srednekolymsk": "Asia/Srednekolymsk",
                "Pacific/Auckland": "Pacific/Auckland",
                "Pacific/Fiji": "Pacific/Fiji",
                "Asia/Kamchatka": "Asia/Kamchatka",
                "Pacific/Majuro": "Pacific/Majuro",
                "Pacific/Chatham": "Pacific/Chatham",
                "Pacific/Tongatapu": "Pacific/Tongatapu",
                "Pacific/Apia": "Pacific/Apia",
                "Pacific/Fakaofo": "Pacific/Fakaofo",
              }
        }
    ],

    outputs: [
        {
            "id": "action",
            "name": "Action",
            "description": "Type: Action\n\nDescription: Executes the following blocks when this block finishes its task.",
            "types": ["action"]
        }
    ],

    async code(cache) {
        var cron = await this.require('node-cron');
        var input = this.GetInputValue("cronInfo", cache) ||  this.GetOptionValue("cronInfo", cache);
        const timezone = this.GetOptionValue("timezone", cache);

        cron.schedule(input, () => {
            this.RunNextBlock('action', cache);
        },{
            scheduled: true,
            timezone: timezone
          });

    }
}