module.exports = {
    name: "Discord Audio Player [Dependency]",

    description: "Starts the Discord Audio Player dependency required for other blocks to work.",

    category: "Dependencies",

    options(data) {
        let options = [];

        const isYouTubeExtractorEnabled = data?.options?.["discord-player-youtubei"] ?? true;
        const isDeezerEnabled = data?.options?.["discord-player-deezer"] ?? false;
        const isYandexMusicEnabled = data?.options?.["discord-player-yandexmusic"] ?? false;
        const isTidalEnabled = data?.options?.["discord-player-tidal"] ?? false;
        const isSoundgasmEnabled = data?.options?.["discord-player-soundgasm"] ?? false;
        const isAppleMusicEnabled = data?.options?.["discord-player-applemusic"] ?? false;
        const isSoundCloudEnabled = data?.options?.["discord-player-soundcloud"] ?? false;
        const isSpotifyEnabled = data?.options?.["discord-player-spotify"] ?? false;
        const isTTSEnabled = data?.options?.["discord-player-tts"] ?? false;

        const youtubeiExtractor = [
            {
                id: "discord-player-youtubei",
                name: "YouTube Extractor",
                description: "Whether to enable the YouTube extractor. Disabling this will prevent playing from YouTube.",
                type: "CHECKBOX",
                defaultValue: true,
            },
        ];

        options.push(youtubeiExtractor);

        // ------------------------------------------

        const deezer = [
            {
                id: "discord-player-deezer",
                name: "Deezer Extractor (Requires ARL)",
                description: "Whether to enable the Deezer extractor. Disabling this will prevent playing from Deezer.",
                type: "CHECKBOX",
            },
        ];

        options.push(deezer);

        if (isDeezerEnabled) {
            options.push({
                id: "discord-player-deezer-arl",
                name: "Deezer Master ARL (Required)",
                description:
                    "The ARL for Deezer. To find it, Login to Your Deezer Account on a Web Browser, Open Developer Tools (F12), Go to Application > Cookies > https://www.deezer.com, Look for the 'arl' Cookie and Copy its Value.",
                type: "TEXT_LINE",
            });
        }

        // ------------------------------------------

        const yandexmusic = [
            {
                id: "discord-player-yandexmusic",
                name: "Yandex Music Extractor (Requires API Key)",
                description: "Whether to enable the Yandex Music extractor. Disabling this will prevent playing from Yandex Music.",
                type: "CHECKBOX",
            },
        ];

        options.push(yandexmusic);

        if (isYandexMusicEnabled)
            yandexmusic.push(
                {
                    id: "discord-player-yandexmusic-access-token",
                    name: "Yandex Music Access Token",
                    description:
                        "The access token for Yandex Music. Follow the Guide at https://github.com/MarshalX/yandex-music-api/discussions/513 to get your Access Token.",
                    type: "TEXT_LINE",
                    defaultValue: "",
                },
                {
                    id: "discord-player-yandexmusic-uid",
                    name: "Yandex Music User ID",
                    description: "The user ID for Yandex Music. To get uid go here https://mail.yandex.ru/. Your uid will be in url.",
                    type: "TEXT_LINE",
                    defaultValue: "",
                }
            );

        // ------------------------------------------

        const tidal = [
            {
                id: "discord-player-tidal",
                name: "Tidal Extractor",
                description: "Whether to enable the Tidal extractor. Disabling this will prevent playing from Tidal.",
                type: "CHECKBOX",
            },
        ];

        options.push(tidal);

        // ------------------------------------------

        const soundgasm = [
            {
                id: "discord-player-soundgasm",
                name: "Soundgasm Extractor",
                description: "Whether to enable the Soundgasm extractor. Disabling this will prevent playing from Soundgasm.",
                type: "CHECKBOX",
            },
        ];

        options.push(soundgasm);

        // ------------------------------------------

        const applemusic = [
            {
                id: "discord-player-applemusic",
                name: "Apple Music Extractor",
                description: "Whether to enable the Apple Music extractor. Disabling this will prevent playing from Apple Music.",
                type: "CHECKBOX",
            },
        ];

        options.push(applemusic);

        // ------------------------------------------

        const soundcloud = [
            {
                id: "discord-player-soundcloud",
                name: "SoundCloud Extractor",
                description: "Whether to enable the SoundCloud extractor. Disabling this will prevent playing from SoundCloud.",
                type: "CHECKBOX",
            },
        ];

        options.push(soundcloud);

        if (isSoundCloudEnabled)
            soundcloud.push(
                {
                    id: "discord-player-soundcloud-client-id",
                    name: "SoundCloud Client ID (Optional)",
                    description:
                        "The Client ID of your SoundCloud application. You can create one at https://developers.soundcloud.com/. If not provided, a default Client ID will be used, which may have limitations.",
                    type: "TEXT_LINE",
                    defaultValue: "",
                },
                {
                    id: "discord-player-soundcloud-oauth-token",
                    name: "SoundCloud OAuth Token (Optional)",
                    description:
                        "The OAuth Token of your SoundCloud application. You can create one at https://developers.soundcloud.com/. If not provided, a default OAuth Token will be used, which may have limitations.",
                    type: "TEXT_LINE",
                    defaultValue: "",
                }
            );

        // ------------------------------------------

        const spotify = [
            {
                id: "discord-player-spotify",
                name: "Spotify Extractor",
                description: "Whether to enable the Spotify extractor. Disabling this will prevent playing from Spotify.",
                type: "CHECKBOX",
                defaultValue: true,
            },
        ];

        options.push(spotify);

        if (isSpotifyEnabled)
            spotify.push(
                {
                    id: "discord-player-spotify-client-id",
                    name: "Spotify Client ID (Optional)",
                    description:
                        "The Client ID of your Spotify application. You can create one at https://developer.spotify.com/dashboard/applications.",
                    type: "TEXT_LINE",
                    defaultValue: "",
                },
                {
                    id: "discord-player-spotify-client-secret",
                    name: "Spotify Client Secret (Optional)",
                    description:
                        "The Client Secret of your Spotify application. You can create one at https://developer.spotify.com/dashboard/applications.",
                    type: "TEXT_LINE",
                    defaultValue: "",
                }
            );

        // ------------------------------------------

        const tts = [
            {
                id: "discord-player-tts",
                name: 'Text-to-Speech (TTS) Extractor ("tts:Your Text Here")',
                description: "Whether to enable the Text-to-Speech (TTS) extractor. Disabling this will prevent playing TTS audio.",
                type: "CHECKBOX",
            },
        ];

        options.push(tts);

        if (isTTSEnabled)
            tts.push({
                id: "discord-player-tts-language",
                name: "TTS Language",
                description: "The language code for the TTS extractor (e.g., 'en' for English, 'es' for Spanish).",
                type: "TEXT_LINE",
                defaultValue: "en",
            });

        // ------------------------------------------

        return options.flat();
    },

    async init(DBB) {
        const { readFileSync } = require("fs");
        const packageManager = require('./!auto_package_manager').getPackageManager();
        const values = JSON.parse(readFileSync(DBB.File.paths.workspaces))
            .map((workspace) => {
                if (workspace.workspaces) {
                    return workspace.workspaces.map((wpc) => wpc.blocks.filter((x) => x.name == "discord_audio_player_dependency")).flat();
                } else {
                    return workspace.blocks.filter((x) => x.name == "discord_audio_player_dependency");
                }
            })
            .filter((x) => x[0])
            .map((x) => x.map((x) => x.options).flat())
            .flat()[0];
        const isYouTubeExtractorEnabled = values?.["discord-player-youtubei"] ?? true;
        const isDeezerEnabled = values?.["discord-player-deezer"] ?? false;
        const isYandexMusicEnabled = values?.["discord-player-yandexmusic"] ?? false;
        const isTidalEnabled = values?.["discord-player-tidal"] ?? false;
        const isSoundgasmEnabled = values?.["discord-player-soundgasm"] ?? false;
        const isAppleMusicEnabled = values?.["discord-player-applemusic"] ?? false;
        const isSoundCloudEnabled = values?.["discord-player-soundcloud"] ?? false;
        const isSpotifyEnabled = values?.["discord-player-spotify"] ?? true;
        const isTTSEnabled = values?.["discord-player-tts"] ?? false;

        const deezerArl = values?.["discord-player-deezer-arl"] ?? "";

        const soundcloudClientId = values?.["discord-player-soundcloud-client-id"] ?? "";
        const soundcloudOAuthToken = values?.["discord-player-soundcloud-oauth-token"] ?? "";

        const yandexMusicAccessToken = values?.["discord-player-yandexmusic-access-token"] ?? "";
        const yandexMusicUid = values?.["discord-player-yandexmusic-uid"] ?? "";

        const spotifyClientId = values?.["discord-player-spotify-client-id"] ?? "";
        const spotifyClientSecret = values?.["discord-player-spotify-client-secret"] ?? "";

        const ttsLanguage = values?.["discord-player-tts-language"] ?? "en";

        try {
            const success = await packageManager?.requires(
                { name: "discord.js", version: "latest" },
                { name: "discord-player", version: "latest" },
                { name: "ffmpeg-static", version: "latest" },
                { name: "axios", version: "latest" },
                isYouTubeExtractorEnabled ? { name: "discord-player-youtubei", version: "latest", uninstall: true } : null, // Uninstall old package if exists
                isYouTubeExtractorEnabled ? { name: "jsdom", version: "latest", dnr: true }             : null,
                isYouTubeExtractorEnabled ? { name: "bgutils-js", version: "latest", dnr: true }        : null,
                isYouTubeExtractorEnabled ? { name: "googlevideo", version: "latest", dnr: true }       : null,
                isYouTubeExtractorEnabled ? { name: "youtubei.js", version: "16.0.1", dnr: true }       : null,
                isYouTubeExtractorEnabled ? { name: "@napi-rs/canvas", version: "latest", dnr: true }   : null,
                isDeezerEnabled ?           { name: "discord-player-deezer", version: "latest" }        : null,
                isYandexMusicEnabled ?      { name: "discord-player-yandexmusic", version: "latest" }   : null,
                isTidalEnabled ?            { name: "discord-player-tidal", version: "latest" }         : null,
                isSoundgasmEnabled ?        { name: "discord-player-soundgasm", version: "latest" }     : null,
                isAppleMusicEnabled ?       { name: "discord-player-applemusic", version: "latest" }    : null,
                isSoundCloudEnabled ?       { name: "discord-player-soundcloud", version: "latest" }    : null,
                isSpotifyEnabled ?          { name: "discord-player-spotify", version: "latest" }       : null,
                isTTSEnabled ?              { name: "discord-player-tts", version: "latest" }           : null
            );
            if (!success) return console.log("Failed to install dependencies! (Discord Audio Player Dependency)");
        } catch (e) {
            return console.log(e);
        }

        const module = require("discord-player");
        if (!DBB.Dependencies.DiscordPlayer) DBB.Dependencies.DiscordPlayer = {};
        DBB.Dependencies.DiscordPlayer.module = require("discord-player");

        process.env.FFMPEG_PATH = require("ffmpeg-static");
        const player = new module.Player(DBB.DiscordJS.client);

        //const { YoutubeiExtractor } = require("discord-player-youtubei");

        if (isYouTubeExtractorEnabled) {
            "use strict";const{Innertube:Innertube,UniversalCache:UniversalCache,Platform:Platform,Constants:Constants,YTNodes:YTNodes}=require("youtubei.js");let ineerTubeInstance=null;async function getInnertube(t){return ineerTubeInstance||(ineerTubeInstance=await Innertube.create({cache:new UniversalCache(!1),cookie:t})),ineerTubeInstance}Platform.shim.eval=async(t,e)=>{const a=[];e.n&&a.push(`n: exportedVars.nFunction("${e.n}")`),e.sig&&a.push(`sig: exportedVars.sigFunction("${e.sig}")`);const n=`${t.output}\nreturn { ${a.join(", ")} }`;return new Function(n)()};const{BG:BG,GOOG_API_KEY:GOOG_API_KEY,USER_AGENT:USER_AGENT,buildURL:buildURL}=require("bgutils-js"),{JSDOM:JSDOM}=require("jsdom"),{createCanvas:createCanvas,ImageData:CanvasImageData}=require("@napi-rs/canvas"),REQUEST_KEY="O43z0dpjhgX20SCx4KAo";let domWindow,botguardClient,webPoMinter,initializationPromise=null,activeScriptId=null,canvasPatched=!1;function patchCanvasSupport(t){if(canvasPatched)return;const e=t?.HTMLCanvasElement;e&&(Object.defineProperty(e.prototype,"_napiCanvasState",{configurable:!0,enumerable:!1,writable:!0,value:null}),e.prototype.getContext=function(t,e){if("2d"!==t)return null;const a=Number.isFinite(this.width)&&this.width>0?this.width:300,n=Number.isFinite(this.height)&&this.height>0?this.height:150,i=this._napiCanvasState||{};return i.canvas?i.canvas.width===a&&i.canvas.height===n||(i.canvas.width=a,i.canvas.height=n):i.canvas=createCanvas(a,n),i.context=i.canvas.getContext("2d",e),this._napiCanvasState=i,i.context},e.prototype.toDataURL=function(...t){if(!this._napiCanvasState?.canvas){const t=Number.isFinite(this.width)&&this.width>0?this.width:300,e=Number.isFinite(this.height)&&this.height>0?this.height:150;this._napiCanvasState={canvas:createCanvas(t,e),context:null}}return this._napiCanvasState.canvas.toDataURL(...t)},t.ImageData||(t.ImageData=CanvasImageData),Reflect.has(globalThis,"ImageData")||Object.defineProperty(globalThis,"ImageData",{configurable:!0,enumerable:!1,writable:!0,value:CanvasImageData}),canvasPatched=!0)}function ensureDomEnvironment(t){if(domWindow)return domWindow;const e=new JSDOM("<!DOCTYPE html><html><head></head><body></body></html>",{url:"https://www.youtube.com/",referrer:"https://www.youtube.com/",userAgent:t});domWindow=e.window;const a={window:domWindow,document:domWindow.document,location:domWindow.location,origin:domWindow.origin,navigator:domWindow.navigator,HTMLElement:domWindow.HTMLElement,atob:domWindow.atob,btoa:domWindow.btoa,crypto:domWindow.crypto,performance:domWindow.performance};for(const[t,e]of Object.entries(a))Reflect.has(globalThis,t)||Object.defineProperty(globalThis,t,{configurable:!0,enumerable:!1,writable:!0,value:e});return Reflect.has(globalThis,"self")||Object.defineProperty(globalThis,"self",{configurable:!0,enumerable:!1,writable:!0,value:globalThis}),patchCanvasSupport(domWindow),domWindow}function resetBotguardState(){if(botguardClient?.shutdown)try{botguardClient.shutdown()}catch{}activeScriptId&&domWindow?.document&&domWindow.document.getElementById(activeScriptId)?.remove(),botguardClient=void 0,webPoMinter=void 0,activeScriptId=null,initializationPromise=null}async function initializeBotguard(t,{forceRefresh:e}={}){if(e&&resetBotguardState(),webPoMinter)return webPoMinter;if(initializationPromise)return await initializationPromise;const a=t.session.context.client.userAgent||USER_AGENT;return ensureDomEnvironment(a),initializationPromise=(async()=>{const e=await t.getAttestationChallenge("ENGAGEMENT_TYPE_UNBOUND"),n=e?.bg_challenge;if(!n)throw new Error("Failed to retrieve Botguard challenge.");const i=n.interpreter_url?.private_do_not_access_or_else_trusted_resource_url_wrapped_value;if(!i)throw new Error("Botguard challenge did not provide an interpreter URL.");if(!domWindow.document.getElementById(i)){const t=await fetch(`https:${i}`,{headers:{"user-agent":a}}),e=await t.text();if(!e)throw new Error("Failed to download Botguard interpreter script.");const n=domWindow.document.createElement("script");n.type="text/javascript",n.id=i,n.textContent=e,domWindow.document.head.appendChild(n),activeScriptId=n.id;new domWindow.Function(e).call(domWindow)}botguardClient=await BG.BotGuardClient.create({program:n.program,globalName:n.global_name,globalObj:globalThis});const r=[],o=await botguardClient.snapshot({webPoSignalOutput:r}),s=await fetch(buildURL("GenerateIT",!0),{method:"POST",headers:{"content-type":"application/json+protobuf","x-goog-api-key":GOOG_API_KEY,"x-user-agent":"grpc-web-javascript/0.1","user-agent":a},body:JSON.stringify([REQUEST_KEY,o])}),c=await s.json(),l=c?.[0];if("string"!=typeof l)throw new Error("Botguard integrity token generation failed.");return webPoMinter=await BG.WebPoMinter.create({integrityToken:l},r),webPoMinter})().catch((t=>{throw resetBotguardState(),t})).finally((()=>{initializationPromise=null})),await initializationPromise}function requireBinding(t){if(!t)throw new Error("Content binding is required to mint a WebPO token.");return t}async function getWebPoMinter(t,e={}){const a=await initializeBotguard(t,e);return{generatePlaceholder:t=>BG.PoToken.generateColdStartToken(requireBinding(t)),mint:async t=>await a.mintAsWebsafeString(requireBinding(t))}}function invalidateWebPoMinter(){resetBotguardState()}async function generateDataSyncTokens(t){try{const e=await t.account.getInfo();console.log(e);const a=e.contents.contents[0].endpoint.payload.supportedTokens[2].datasyncIdToken.datasyncIdToken;if(!a)throw new Error("Data Sync ID not found in account info");console.log("Data Sync ID:",a);const n=await getWebPoMinter(t),i=await n.mint(a);return console.log("Full Token:",i),{dataSyncId:a,fullToken:i}}catch(t){throw console.error("Error generating Data Sync tokens:",t),t}}const{EnabledTrackTypes:EnabledTrackTypes,buildSabrFormat:buildSabrFormat}=require("googlevideo/utils"),{SabrStream:SabrStream}=require("googlevideo/sabr-stream"),{Readable:Readable,PassThrough:PassThrough,once:once}=require("stream"),DEFAULT_OPTIONS={audioQuality:"AUDIO_QUALITY_MEDIUM",enabledTrackTypes:EnabledTrackTypes.AUDIO_ONLY};function toNodeReadable(t){const e=new PassThrough,a=t.getReader();return(async()=>{try{for(;;){const{done:t,value:n}=await a.read();if(t)break;n&&(e.write(Buffer.from(n))||await once(e,"drain"))}}finally{e.end()}})(),e}async function createSabrStream(t,e,a=!1){const n=await getInnertube(e);let i=null;try{i=await n.account.getInfo()}catch(t){i=null}const r=i?.contents?.contents[0]?.endpoint?.payload?.supportedTokens?.[2]?.datasyncIdToken?.datasyncIdToken??n.session.context.client.visitorData,o=await getWebPoMinter(n),s=await o.mint(t),c=await o.mint(r),l=new YTNodes.NavigationEndpoint({watchEndpoint:{videoId:t}}),u=await l.call(n.actions,{playbackContext:{adPlaybackContext:{pyv:!0},contentPlaybackContext:{vis:0,splay:!1,lactMilliseconds:"-1",signatureTimestamp:n.session.player?.signature_timestamp}},contentCheckOk:!0,racyCheckOk:!0,serviceIntegrityDimensions:{poToken:c},parse:!0}),d=await(n.session.player?.decipher(u.streaming_data?.server_abr_streaming_url)),h=u.player_config?.media_common_config.media_ustreamer_request_config?.video_playback_ustreamer_config;if(!h)throw new Error("ustreamerConfig not found");if(!d)throw new Error("serverAbrStreamingUrl not found");const b=u.streaming_data?.adaptive_formats.map(buildSabrFormat)||[],m=new SabrStream({formats:b,serverAbrStreamingUrl:d,videoPlaybackUstreamerConfig:h,poToken:s,clientInfo:{clientName:parseInt(Constants.CLIENT_NAME_IDS[n.session.context.client.clientName]),clientVersion:n.session.context.client.clientVersion}});let w=0,g=null;m.on("streamProtectionStatusUpdate",(async e=>{if(e.status!==g&&(a&&console.log("Stream Protection Status Update:",e),g=e.status),2===e.status){w=Math.min(w+1,10),1!==w&&w%5!=0||a&&console.log(`Rotating PO token... (attempt ${w})`);try{const e=await getWebPoMinter(n,{forceRefresh:w>=3}),a=e.generatePlaceholder(t);m.setPoToken(a);const i=await e.mint(t);m.setPoToken(i)}catch(t){1!==w&&w%5!=0||a&&console.error("Failed to rotate PO token:",t)}}else 3===e.status?(a&&console.error("Stream protection rejected token (SPS 3). Resetting Botguard."),invalidateWebPoMinter()):w=0})),m.on("error",(t=>{a&&console.error("SABR stream error:",t)}));const{audioStream:p}=await m.start(DEFAULT_OPTIONS);return toNodeReadable(p)}const{BaseExtractor:BaseExtractor,Track:Track,Playlist:Playlist,Util:Util}=require("discord-player");class YoutubeSabrExtractor extends BaseExtractor{static identifier="com.itsmaat.discord-player.youtube-sabr";async activate(){this.protocols=["youtube","yt"],this.cookies=this.options.cookies,this.logSabrEvents=this.options.logSabrEvents,this.innertube=await getInnertube(this.cookies);const t=this.options.createStream;"function"==typeof t&&(this._stream=e=>t(this,e))}async deactivate(){this._stream=null,this.innertube=null}async validate(t,e){return"string"==typeof t&&(!isUrl(t)||/^https?:\/\/(www\.)?(youtube\.com|youtu\.be)\//i.test(t))}async handle(t,e){try{if(!isUrl(t)){const a=(await this.innertube.search(t)).videos.filter((t=>"Video"===t.type)),n=[];for(const t of a.slice(0,10)){const a=await this.innertube.getBasicInfo(t.id),i=1e3*(a.basic_info?.duration??0);n.push(new Track(e.player,{title:a.basic_info?.title??`YouTube:${t.id}`,author:a.basic_info?.author??null,url:`https://www.youtube.com/watch?v=${t.id}`,thumbnail:t.thumbnails[0]?.url,duration:Util.buildTimeCode(Util.parseMS(i)),source:"youtube-sabr",requestedBy:e.requestedBy??null,raw:{basicInfo:a,live:a.basic_info?.is_live||!1}}))}return this.createResponse(null,n)}let a=!1,n=null;const i=new URL(t),r=i.searchParams.has("list"),o=/(^|\.)youtu\.be$/i.test(i.hostname);if(a=r&&!o,n=a?i.searchParams.get("list"):null,a&&n){let a=await this.innertube.getPlaylist(n);if(!a?.videos?.length)return this.createResponse(null,[]);const i=new Playlist(e.player,{id:n,title:a.info.title??"Unknown",url:t,thumbnail:a.info.thumbnails[0].url,description:a.info.description??a.info.title??"UNKNOWN DESCRIPTION",source:"youtube",type:"playlist",author:{name:a?.channels[0]?.author?.name??a.info.author.name??"UNKNOWN AUTHOR",url:a?.channels[0]?.author?.url??a.info.author.url??"UNKNOWN AUTHOR"},tracks:[],requestedBy:e.requestedBy??null});i.tracks=[];const r=a.videos.filter((t=>"PlaylistVideo"===t.type)).map((t=>{const a=Util.buildTimeCode(Util.parseMS(1e3*t.duration.seconds)),n={duration_ms:1e3*t.duration.seconds,live:t.is_live,duration:a};return new Track(this.context.player,{title:t.title.text??"UNKNOWN TITLE",duration:a,thumbnail:t.thumbnails[0]?.url,author:t.author.name,requestedBy:e.requestedBy,url:`https://youtube.com/watch?v=${t.id}`,raw:n,playlist:i,source:"youtube",queryType:"youtubeVideo",async requestMetadata(){return this.raw},metadata:n,live:t.is_live})}));for(;a.has_continuation;)a=await a.getContinuation(),r.push(...a.videos.filter((t=>"PlaylistVideo"===t.type)).map((t=>{const a=Util.buildTimeCode(Util.parseMS(1e3*t.duration.seconds)),n={duration_ms:1e3*t.duration.seconds,live:t.is_live,duration:a};return new Track(this.context.player,{title:t.title.text??"UNKNOWN TITLE",duration:a,thumbnail:t.thumbnails[0]?.url,author:t.author.name,requestedBy:e.requestedBy,url:`https://youtube.com/watch?v=${t.id}`,raw:n,playlist:i,source:"youtube",queryType:"youtubeVideo",async requestMetadata(){return this.raw},metadata:n,live:t.is_live})})));return i.tracks=r,this.createResponse(i,r)}const s=extractVideoId(t);if(!s)return this.createResponse(null,[]);const c=await this.innertube.getBasicInfo(s),l=1e3*(c.basic_info?.duration??0),u=new Track(e.player,{title:c.basic_info?.title??`YouTube:${s}`,author:c.basic_info?.author??null,url:`https://www.youtube.com/watch?v=${s}`,thumbnail:c.basic_info?.thumbnail[0].url,duration:Util.buildTimeCode(Util.parseMS(l)),source:"youtube-sabr",requestedBy:e.requestedBy??null,raw:{basicInfo:c,live:c.basic_info?.is_live||!1}});return this.createResponse(null,[u])}catch(t){return console.error("[YoutubeSabrExtractor handle error]",t),this.createResponse(null,[])}}async stream(t){try{if(!this.innertube)throw new Error("Innertube not initialized; call activate() first");const e=extractVideoId(t.url||t.raw?.id||"");if(!e)throw new Error("Unable to extract video id from track.url");return await createSabrStream(e,this.cookies,this.logSabrEvents)}catch(t){throw console.error(t),t}}}function isUrl(t){try{const e=new URL(t);return["https:","http:"].includes(e.protocol)}catch(t){return!1}}function extractVideoId(t){if(!/^https:\/\/(www\.)?youtu(\.be\/.{11}(.+)?|be\.com\/watch\?v=.{11}(&.+)?)/.test(t))throw new Error("Invalid youtube url");let e=new URL(t).searchParams.get("v");return e||(e=t.split("/").at(-1)?.split("?").at(0)),e}function extractPlaylistId(t){try{return new URL(t).searchParams.get("list")}catch{return null}}async function resolveFinalUrl(t){try{if("function"!=typeof fetch)return t;try{const e=await fetch(t,{method:"HEAD",redirect:"follow"});if(e?.url)return e.url}catch(t){}const e=await fetch(t,{method:"GET",redirect:"follow"});return e?.url||t}catch(e){return t}}module.exports={getInnertube:getInnertube,getWebPoMinter:getWebPoMinter,invalidateWebPoMinter:invalidateWebPoMinter,generateDataSyncTokens:generateDataSyncTokens,createSabrStream:createSabrStream,YoutubeSabrExtractor:YoutubeSabrExtractor};
            await player.extractors.register(YoutubeSabrExtractor, {
                logSabrEvents: false
            });
        }

        if (isDeezerEnabled && deezerArl) {
            const { DeezerExtractor } = require("discord-player-deezer");
            await player.extractors.register(DeezerExtractor, { 
                    arl: deezerArl,
                    decryptionKey: "4f9512ef59ad5f2446e2fbbf6dd7b71f"
                });
        } else if (isDeezerEnabled) DBB.Core.console("WARN", "Deezer extractor is enabled but ARL is missing. Skipping registration.");

        if (isYandexMusicEnabled && yandexMusicAccessToken && yandexMusicUid) {
            const { YandexMusicExtractor } = require("discord-player-yandexmusic");
            await player.extractors.register(YandexMusicExtractor, { accessToken: yandexMusicAccessToken, uid: yandexMusicUid });
        } else if (isYandexMusicEnabled) DBB.Core.console("WARN", "Yandex Music extractor is enabled but Access Token or UID is missing. Skipping registration.");

        if (isTidalEnabled) {
            const TidalExtractor = require("discord-player-tidal")?.default;
            await player.extractors.register(TidalExtractor);
        }
        
        if (isSoundgasmEnabled) {
            const { SoundgasmExtractor } = require("discord-player-soundgasm");
            await player.extractors.register(SoundgasmExtractor);
        }
        
        if (isAppleMusicEnabled) {
            const { AppleMusicExtractor } = require("discord-player-applemusic");
            await player.extractors.register(AppleMusicExtractor);
        }
        
        if (isSoundCloudEnabled) {
            const { SoundcloudExtractor } = require("discord-player-soundcloud");
            if (soundcloudClientId && soundcloudOAuthToken) {
                await player.extractors.register(SoundcloudExtractor, { clientId: soundcloudClientId, oauthToken: soundcloudOAuthToken });
            } else {
                await player.extractors.register(SoundcloudExtractor);
            }
        }
        
        if (isSpotifyEnabled) {
            const { SpotifyExtractor } = require("discord-player-spotify");
            if (spotifyClientId && spotifyClientSecret) {
                await player.extractors.register(SpotifyExtractor, { clientId: spotifyClientId, clientSecret: spotifyClientSecret });
            } else {
                await player.extractors.register(SpotifyExtractor);
            }
        }

        if (isTTSEnabled) {
            const { TTSExtractor } = require("discord-player-tts");
            await player.extractors.register(TTSExtractor, { language: ttsLanguage });
        }

        DBB.Dependencies.DiscordPlayer.player = player;
    },
};
