module.exports = {
    name: "Slot Machine",

    description: "Simulates a slot machine game with multipliers.",

    category: "Fun",
    // Created By SacredLight
    inputs: [
        {
            "id": "action",
            "name": "Action",
            "description": "Executes this block.",
            "types": ["action"]
        },
        {
            "id": "bet_amount",
            "name": "Bet Amount",
            "description": "The amount the player is betting.",
            "types": ["number"],
            "required": true
        }
    ],

    options: [],

    outputs: [
        {
            "id": "action_win",
            "name": "Action Win",
            "description": "Executes the next block if the player wins.",
            "types": ["action"]
        },
        {
            "id": "action_loss",
            "name": "Action Loss",
            "description": "Executes the next block if the player loses.",
            "types": ["action"]
        },
        {
            "id": "action",
            "name": "Action",
            "description": "Executes the next block regardless.",
            "types": ["action"]
        },
        {
            "id": "win_loss_amount",
            "name": "Win / Loss Amount",
            "description": "The amount the player wins or loses.",
            "types": ["number"]
        },
        {
            "id": "symbols",
            "name": "Symbols",
            "description": "The symbols generated by the slot machine.",
            "types": ["string"]
        }
    ],

    code(cache) {
        const symbols = [
            { symbol: "🍒", multiplier: 2 }, //Set The Multipliers Here. 2 is 2X the bet amount ect.
            { symbol: "🍋", multiplier: 3 },
            { symbol: "🍊", multiplier: 4 },
            { symbol: "🍇", multiplier: 5 },
            { symbol: "🔔", multiplier: 6 },
            { symbol: "⭐", multiplier: 10 },
            { symbol: "💰", multiplier: 20 }
        ];

        const betAmount = this.GetInputValue("bet_amount", cache);
        const result = [];

        for (let i = 0; i < 3; i++) {
            // Adjust probabilities here by adding more frequent symbols
            const randomIndex = Math.floor(Math.random() * (symbols.length + 6)); // Increase from 6 for more frequent wins
            const symbolIndex = randomIndex < symbols.length ? randomIndex : randomIndex % symbols.length;
            result.push(symbols[symbolIndex].symbol);
        }

        const resultString = result.join("  |  ");
        this.StoreOutputValue(resultString, "symbols", cache);

        if (result.every(symbol => symbol === result[0])) {
            const multiplier = symbols.find(s => s.symbol === result[0]).multiplier;
            const winAmount = betAmount * multiplier;
            this.StoreOutputValue(winAmount, "win_loss_amount", cache);
            this.RunNextBlock("action_win", cache);
        } else {
            this.StoreOutputValue(-betAmount, "win_loss_amount", cache);
            this.RunNextBlock("action_loss", cache);
        }

        this.RunNextBlock("action", cache);
    }
};
